-- AASM 250 by Currenthill

-- =============================== AASM 250 HAMMER aircraft-launched PGM ==========================================

  CH_AASM_250 = {
	category		= CAT_MISSILES,
	name			= "CH_AASM250",
	displayName		= _("[CH] AASM 250 PGM"),
	user_name	 	= _("AASM 250"),
	mass			= 340,
	model			= 'CH_AASM250',
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	Escort 			= 0,
	Head_Type 		= 5,  
	sigma 			= {1, 1, 1},
	M 				= 340.0,   
	H_max 			= 40000.0,  
	H_min 			= 200,  
	Diam 			= 300.0,
	Cx_pil 			= 1,   
	D_max 			= 80000.0, 
	D_min 			= 10000.0,
	Head_Form 		= 0, 
	Life_Time 		= 9999.0,   
	Nr_max 			= 12,  
	v_min 			= 170.0,
	v_mid 			= 450.0,  
	Mach_max 		= 1.3,  
	t_b 			= 0.0,
	t_acc 			= 4.0, 
	t_marsh         = 1800.0,  
	Range_max 		= 80000.0, 
	H_min_t 		= 0.0,
	Fi_start 		= 3.14152,
    Fi_rak 			= 3.14152,
    Fi_excort 		= 3.14152,
    Fi_search 		= 99.9,
    OmViz_max 		= 99.9,	
	exhaust 		= { 1, 1, 1, 1 },
	X_back 			= -6.3,  
	Y_back 			= 0.0, 
	Z_back 			= 0.0,  
	Reflection 		= 0.04, 
	KillDistance 	= 0.0, 
	add_attributes = {"Cruise missiles"},	
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, 
		},
	},	

	warhead	= predefined_warhead("Mk_82"),
	warhead_air = predefined_warhead("Mk_82"),

	shape_table_data = 
	{
		{

			name	 = "CH_AASM250";
			file  	 = "CH_AASM250";   		
			life  	 = 1;
			fire  	 = { 0, 1};
			username = _("AASM 250");
			index = WSTYPE_PLACEHOLDER;
		},
	},

    LaunchDistData =
	{
		4,		5,

				100,	165,	230,	300,	400,		
		500,	10000,	20000,	30000,	40000,	50000,	
		2000,	20000,	30000,	40000,	50000,	60000,	
		5000,	30000,	40000,	50000,	60000,	70000,	
		10000,	40000,	50000,	60000,	70000,	80000,	
	},
	
    class_name      = "wAmmunitionCruise",
    scheme          = "sat_cruise_missile",

	fm = {
		mass        = 1950,  
		caliber     = 0.697,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 6.6,
		I           = 1 / 12 * 2050.0 * 6.6 * 6.6,
		Ma          = 3,
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.7,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 1,
		wingsDeplDelay		= 1,	
	},
	
	seeker = {
		CEP 					= 1.0,		
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},
	
	control_block ={
		seeker_activation_dist		= 6000,
		default_cruise_height		= 1500,
		obj_sensor					= 0,
		can_update_target_pos		= 1,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.5,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 450,
		use_horiz_dist				= 1,
		stab_aim_diff				= 0.1,
	},

	final_autopilot =		{
		delay				= 0,
		K					= 70,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 0,
		J_Power_K			= 2.2,
		J_Diff_K			= 0.4,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.18,
		J_FinAngle_K		= 0.32,
		J_Angle_W			= 0.8,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 0,
		auto_terrain_following_height	= 1500,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 50,
		stab_vel			= 220,
		finsLimit			= 0.8,
		estimated_N_max		= 10,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,		
		
		inertial_km_error		= 1,		-- m for 1000m dist
		glide_height_eq_error	= 1,		-- percent
		glide_height_abs_error	= 1,
		stab_vel_abs_error		= 1.0,		
	},
	
	controller = {
		boost_start	= 2,
		march_start = 32,
	},

	boost = {	
		impulse								= 400,
		fuel_mass							= 50,
		work_time							= 30,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-1.64, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.8,
        smoke_color							= {0.6, 0.6, 0.6},
        smoke_transparency					= 0.8,
        custom_smoke_dissipation_factor		= 0.2,  			
	},

	march = {
		impulse			= 0,
		fuel_mass		= 0,
		work_time		= 0,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
        nozzle_position                  	= {{-1.58, 0.0, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.6,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.5,
		custom_smoke_dissipation_factor		= 0.7,	
		
		start_burn_effect			= 0,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},
	
	booster_animation = {
		start_val = 0,
	},
	
	play_booster_animation = {
		val = 0,
	},
	
}

declare_weapon(CH_AASM_250)

declare_loadout(
	{
		category		= CAT_MISSILES,
		Picture			= "AASM250.png",
		wsTypeOfWeapon  = CH_AASM_250.wsTypeOfWeapon,		
		displayName		= _("[CH] AASM 250 PGM"),
		CLSID			= "{CH_AASM250}",
		attribute		= CH_AASM_250.wsTypeOfWeapon,
		Count			= 1,
		Weight			= CH_AASM_250.mass,
		Cx_pil			= 0.001, 	
		Elements		=
	{
		[1]	=	
		{
				DrawArgs	=
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"CH_AASM250",
					},
		}, -- end of Elements   
	}
)
